from huggingface_hub import snapshot_download
import os

# Funcion para solicitar la ruta de guardado
def elegir_ruta():
    print("\nAVISO: Introduce la ruta de guardado usando barras normales (/).")
    print("- Ejemplo para Windows: C:/Users/TuUsuario/Documents/Models")
    print("- Ejemplo para macOS: /Users/TuUsuario/Documents/Models")
    print("Asegurate de que la ruta exista o tenga permisos de escritura.\n")

    print("\n¿Donde deseas guardar el modelo?")
    print("1. Usar ruta predeterminada (C:/Models)")
    print("2. Especificar una ruta manualmente")
    opcion_ruta = input("Introduce el numero correspondiente: ")

    if opcion_ruta == "1":
        # Ruta predeterminada: C:/Models
        return "C:/Models"
    elif opcion_ruta == "2":
        ruta_manual = input("Introduce la ruta completa donde deseas guardar el modelo: ")
        # Reemplaza las barras invertidas con barras normales (por si el usuario las usa)
        ruta_manual = ruta_manual.replace("\\", "/")
        return ruta_manual
    else:
        print("Opcion no valida. Usando ruta predeterminada (C:/Models).")
        return "C:/Models"

# Pide al usuario que elija el modelo
print("Selecciona el modelo que deseas descargar:")
print("1. DeepSeek V3 Base Model")
print("2. DeepSeek V3 Chat Model")
opcion = input("Introduce el numero correspondiente al modelo: ")

# Asigna el nombre del modelo y la carpeta segun la eleccion del usuario
if opcion == "1":
    modelo_nombre = "deepseek-ai/DeepSeek-V3-Base"
    nombre_carpeta = "DeepSeek_V3_Base"
elif opcion == "2":
    modelo_nombre = "deepseek-ai/DeepSeek-V3-Chat"
    nombre_carpeta = "DeepSeek_V3_Chat"
else:
    print("Opcion no valida. Saliendo del programa.")
    exit()

# Solicita al usuario que elija la ruta de guardado
ruta_base = elegir_ruta()
ruta_guardado = os.path.join(ruta_base, nombre_carpeta).replace("\\", "/")  # Usamos barras normales

# Asegurate de que el directorio exista
os.makedirs(ruta_guardado, exist_ok=True)

# Descarga el repositorio sin ejecutarlo
snapshot_download(
    repo_id=modelo_nombre,
    local_dir=ruta_guardado,
    local_dir_use_symlinks=False,  # Evita el uso de enlaces simbolicos
    token="TU-TOKEN-DEEPSEEK"  # Solo si el modelo es privado
)

print(f"Modelo descargado en: {ruta_guardado}")